/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.furniture;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.furniture.FurnitureEntityAssetsByMaterialType;
import technology.rocketjump.undermount.assets.entities.furniture.model.FurnitureEntityAsset;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureLayoutDictionary;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;

public class FurnitureEntityAssetsByLayout {
    private Map<String, FurnitureEntityAssetsByMaterialType> byLayoutName = new HashMap<String, FurnitureEntityAssetsByMaterialType>();

    public FurnitureEntityAssetsByLayout(FurnitureLayoutDictionary layoutDictionary) {
        for (FurnitureLayout furnitureLayout : layoutDictionary.getAll()) {
            this.byLayoutName.put(furnitureLayout.getUniqueName(), new FurnitureEntityAssetsByMaterialType());
        }
    }

    public void add(FurnitureEntityAsset asset) {
        String layoutName = asset.getFurnitureLayoutName();
        if (layoutName == null) {
            throw new RuntimeException("Layout name must be specified for " + asset);
        }
        if (!this.byLayoutName.containsKey(layoutName)) {
            throw new RuntimeException("Could not match layout by name " + layoutName + " in " + this.getClass().getSimpleName());
        }
        this.byLayoutName.get(layoutName).add(asset);
    }

    public FurnitureEntityAsset get(FurnitureEntityAttributes attributes) {
        String layoutName = attributes.getCurrentLayout().getUniqueName();
        return this.byLayoutName.get(layoutName).get(attributes);
    }

    public List<FurnitureEntityAsset> getAll(FurnitureEntityAttributes attributes) {
        String layoutName = attributes.getCurrentLayout().getUniqueName();
        return this.byLayoutName.get(layoutName).getAll(attributes);
    }
}

